
import javax.swing.filechooser.FileSystemView;

PGraphics positive;
PGraphics negative;
boolean toggle = false;
boolean mousePressedOnce = false;
boolean cursorHidden = false;

int w = 600;
int h = 400;

void setup() {

frame.setIconImage( getToolkit().getImage("icon.png"));
  
  size(680, 480, P3D);
  frameRate(60);
  noSmooth();
  frame.setTitle("screen");
  
  positive = createGraphics(w-80, h-80, P2D);
  negative = createGraphics(w-80, h-80, P2D);
  
  positive.beginDraw();
  positive.background(255);
  positive.endDraw();
  
  negative.beginDraw();
  negative.background(0);
  negative.endDraw();

  noStroke();
  background(0);
  fill(255);
  rect(40+width/2-w/2, 40+height/2-h/2, w-80, h-80);
}

void draw() {
}

void mousePressed() {
  render_positive();
}

void mouseReleased() {
  render_negative();
}

void mouseMoved() {
  render_negative();
}

void mouseDragged() {
  render_positive();
}

void render_positive() {
  
  if (!mousePressedOnce) mousePressedOnce=true;
  background(0);
  positive.beginDraw();
  positive.stroke(0);
  positive.line(pmouseX-width/2+w/2-40, pmouseY-height/2+h/2-40, mouseX-width/2+w/2-40, mouseY-height/2+h/2-40);
  positive.endDraw();
  image(positive, 40+width/2-w/2, 40+height/2-h/2);
}

void render_negative() {
  if (mousePressedOnce) {
    background(255);
    negative.beginDraw();
    negative.stroke(255);
    negative.line(pmouseX-width/2+w/2-40, pmouseY-height/2+h/2-40, mouseX-width/2+w/2-40, mouseY-height/2+h/2-40);
    negative.endDraw();
    image(negative, 40+width/2-w/2, 40+height/2-h/2);
  }
}

void keyPressed() {

  switch(keyCode) {
  case ESC:
    stop();
    break;
  }
}

public void exit(){

  FileSystemView filesys = FileSystemView.getFileSystemView();
  positive.save(filesys.getHomeDirectory()+"/Desktop/positive.png");
  negative.save(filesys.getHomeDirectory()+"/Desktop/negative.png");
  System.exit(1);
}


